import Image, ImageChops, ImageEnhance, os, glob, sys, math
from collections import deque
from operator import itemgetter

two_back = ''
prior = ''
cur = ''
diff = ''

width, height = 0, 0

values = []


fps = 30
filt = True # if true, filter by time
step = 1./fps # how long each frame is
interval = 1 # how many frames to count as one measurement
time = 0.0
cur_amp = 0.0 # accumulate amplitudes

if filt:
  # get times to filter on in seconds
  starttime = int(sys.argv[2])
  endtime = int(sys.argv[3])

counter = 0
for f in sorted(glob.glob(sys.argv[1]+'*.png')): 

  frame_num = int(f.split('_')[-1].split('.')[0])
  time = (frame_num - 1) * step

  if frame_num % 500 == 0 and frame_num > 0:
    print >> sys.stderr, '\t%i frames processed' %frame_num
  
  if filt:
    if time <= starttime or time >= endtime: 
      #print >> sys.stderr, 'skipping frame %i at time %f because it was out of time' %(frame_num,time)
      continue
  
  if cur == '':
    cur = Image.open(f)
    continue
  if prior == '':
    prior = cur
    cur = Image.open(f)
    continue
  
  prior = cur
  cur = Image.open(f)
  diff = ImageChops.difference(prior, cur)
  
  width, height = diff.size
  pix = diff.load()
  for j in xrange(width):
    for k in xrange(height):
      cur_amp += sum(pix[j, k])/3.0
  counter += 1

  if time > 0 and counter % interval == 0:
    print frame_num, '\t', cur_amp, '\t', time
    cur_amp = 0.0
