# given a textgrid silence/sounding file, calculates the average length of all vocalized turns

import sys
import numpy as np

start = False
xmax = 0.0
xmin = 0.0

collected = []

starttime = float(sys.argv[2])
endtime = float(sys.argv[3])

for l in open(sys.argv[1]):
    if 'name = "silences"' in l:
        start = True

    if start:
        if 'xmin' in l:
            xmin = float(l.split()[-1])
        elif 'xmax' in l:
            xmax = float(l.split()[-1])
        elif 'text' in l:
            if 'sounding' in l:
                if xmin >= starttime and xmax <= endtime: # filter to appropriate times
                    collected.append(xmax-xmin)
            else:
                xmax = 0.0
                xmin = 0.0

if len(sys.argv) > 4:
    print 'avg %f' %np.mean(collected)
    print 'std %f' %np.std(collected)
    print 'max %f' %np.max(collected)
    print 'min %f' %np.min(collected)
else:
    print np.mean(collected)


