# Rob Voigt
# From an audio file, create a textgrid that has silent/sounding intervals which are approximate phrases (PBUs)

# Input parameters
form Find IPs By Analyzing Silences
	text audiofile sound.wav
	text gridfile sound.TextGrid
	real dbVal -30.0	
endform

# Set variable values to the default


# Confirm that the audio file exists
if (not (fileReadable(audiofile$)))
    printline "audiofile not readable"
    exit
endif

# Open audio file
Read from file... 'audiofile$'
soundname$ = selected$("Sound")

select Sound 'soundname$'
To Intensity... 100 0 yes
select Intensity 'soundname$'
To TextGrid (silences)... dbVal 0.2 0.1 silent sounding
select TextGrid 'soundname$'
Save as text file... 'gridfile$'